<?php
include 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['foto']) && isset($_POST['aluno_id'])) {
    $aluno_id = intval($_POST['aluno_id']);
    $foto = $_FILES['foto'];

    $pasta_destino = 'fotos_alunos/';
    if (!is_dir($pasta_destino)) {
        mkdir($pasta_destino, 0755, true);
    }

    if ($foto['error'] === UPLOAD_ERR_OK) {
        $extensao = strtolower(pathinfo($foto['name'], PATHINFO_EXTENSION));
        $tipos_permitidos = ['jpg', 'jpeg', 'png', 'gif'];

        if (in_array($extensao, $tipos_permitidos)) {
            $novo_nome = 'aluno_' . $aluno_id . '.' . $extensao;
            $destino = $pasta_destino . $novo_nome;

            if (move_uploaded_file($foto['tmp_name'], $destino)) {
                // Atualiza o nome da foto no banco de dados
                $stmt = $conn->prepare("UPDATE alunos SET foto = ? WHERE id = ?");
                $stmt->bind_param("si", $novo_nome, $aluno_id);
                if ($stmt->execute()) {
                    // Redireciona com o ID para recarregar o formulário com a foto
                    header("Location: matricular_aluno.php?aluno_id=$aluno_id&foto=$novo_nome");
                    exit();
                } else {
                    echo "❌ Erro ao salvar no banco de dados: " . $stmt->error;
                }
            } else {
                echo "❌ Erro ao mover o arquivo para a pasta.";
            }
        } else {
            echo "❌ Tipo de arquivo não permitido.";
        }
    } else {
        echo "❌ Erro no upload: código " . $foto['error'];
    }
}
?>
